/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui;

import com.aptana.core.IMap;
import com.aptana.core.util.BrowserUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.IBrowserUtil;
import com.aptana.ui.IBrowserProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ui.internal.browser.BrowserDescriptorWorkingCopy;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserManager
implements IBrowserProvider {
    private static IBrowserProvider instance;

    public static synchronized IBrowserProvider getInstance() {
        if (instance == null) {
            instance = new BrowserManager();
        }
        return instance;
    }

    private BrowserManager() {
    }

    private String getRealPath(String loc) {
        String path;
        if (loc == null) {
            return null;
        }
        File file = new File(loc);
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    @Override
    public Collection<IBrowserUtil.BrowserInfo> searchMoreBrowsers() {
        org.eclipse.ui.internal.browser.BrowserManager eclipseBrowserManager = this.getEclipseBrowserManager();
        List webBrowsers = eclipseBrowserManager.getWebBrowsers();
        HashSet<String> currentBrowsers = new HashSet<String>();
        for (IBrowserDescriptor iBrowserDescriptor : webBrowsers) {
            String path = this.getRealPath(iBrowserDescriptor.getLocation());
            if (path == null) continue;
            currentBrowsers.add(path);
        }
        ArrayList<IBrowserUtil.BrowserInfo> browsersFound = new ArrayList<IBrowserUtil.BrowserInfo>();
        List discoverInstalledBrowsers = BrowserUtil.discoverInstalledBrowsers();
        boolean needSave = false;
        for (IBrowserUtil.BrowserInfo browserInfo : discoverInstalledBrowsers) {
            String browserLocation = this.getRealPath(browserInfo.getLocation());
            if (browserLocation == null || currentBrowsers.contains(browserLocation)) continue;
            currentBrowsers.add(browserLocation);
            BrowserDescriptorWorkingCopy workingCopy = new BrowserDescriptorWorkingCopy();
            workingCopy.setName(browserInfo.getName());
            workingCopy.setLocation(browserInfo.getLocation());
            workingCopy.save();
            browsersFound.add(browserInfo);
            needSave = true;
        }
        if (needSave) {
            eclipseBrowserManager.setCurrentWebBrowser(eclipseBrowserManager.getCurrentWebBrowser());
        }
        return browsersFound;
    }

    protected org.eclipse.ui.internal.browser.BrowserManager getEclipseBrowserManager() {
        return org.eclipse.ui.internal.browser.BrowserManager.getInstance();
    }

    @Override
    public List<IBrowserUtil.BrowserInfo> getWebBrowsers() {
        List webBrowsers = this.getEclipseBrowserManager().getWebBrowsers();
        return CollectionsUtil.map((Collection)webBrowsers, (IMap)new IMap<IBrowserDescriptor, IBrowserUtil.BrowserInfo>(){

            public IBrowserUtil.BrowserInfo map(IBrowserDescriptor browser) {
                if (browser == null) {
                    return null;
                }
                return new IBrowserUtil.BrowserInfo(browser.getName(), browser.getLocation());
            }
        });
    }

    @Override
    public IBrowserUtil.BrowserInfo getCurrentWebBrowser() {
        IBrowserDescriptor currentWebBrowser = this.getEclipseBrowserManager().getCurrentWebBrowser();
        if (currentWebBrowser == null) {
            return null;
        }
        return new IBrowserUtil.BrowserInfo(currentWebBrowser.getName(), currentWebBrowser.getLocation());
    }

    @Override
    public String getBrowserVersion(IBrowserUtil.BrowserInfo info) {
        return BrowserUtil.getBrowserVersion((IBrowserUtil.BrowserInfo)info);
    }
}

